* NDNS derived variables for alcohol consumption for interview data

/*	The interview and dietary data had already been merged by the time I came back to this, so no documentation - but see the log files in the main
	NDNS directory for a (painstaking...) record of this		*/

* This follows the way of conducting this in the NDNS user guide, p823-, convereted from SPSS to Stata


******************************************************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************

* STEP 0: DATA CLEANING FOR OTHER AMOUNTS...  Thankfully not many to do (unlike Omnibus)

list caseid xbeerq if xbeerq ~= ""
capture drop beerq5
gen beerq5 = .
replace beerq5 = 10 if caseid ==12937		// As in NDNS documentation, 3 litres recoded as 10 half pints
replace beerq5 = 7 if caseid == 23511   		// As in NDNS documentation, 2 litres (strong cider) recoded as 7 half pints
replace beerq5 = 1 if caseid == 15416 		// As in NDNS documentation, 1/4 litre is 1 half pint
replace beerq4 = 2 if caseid == 21320 		// As in NDNS documentation, 2 small bottles are assumed to be bottles in general

list caseid xspiritq if xspiritq ~= ""		// No spirits vals need recoding

list caseid xsherryq if xsherryq ~= ""
replace sherryq = 0.67/0.05 if caseid == 19616

list caseid xwineq if xwineq~= ""
replace wineq = 0.5 if caseid == 21627
save allalc, replace


******************************************************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************

/* MISSING VALUES: abstainers are system-missing for the alcohol vars (i.e. ".").  However, dk or refusal are coded as 99 and 98 respectively in 
	the 'beer', 'spirits' etc. vars, and these are converted to .d and .r respectively.		*/
mvdecode beer shandy spirits sherry wine alcpop, mv (98=.r \ 99=.d)

* STEP 1: get beerq1-beerq4 to convert to nbeerq1-nbeerq4 to relate to half pints, small cans, large cans and bottles, rather than the first specified
capture drop bunits nbeerq*
gen bunits = .
gen nbeerq1 = .
label var nbeerq1 "Beer: num 1/2 pints"
gen nbeerq2 = .
label var nbeerq2 "Beer: num small cans"
gen nbeerq3 = .
label var nbeerq3 "Beer: num large cans"
gen nbeerq4 = .
label var nbeerq4 "Beer: num bottles"
gen nbeerq5 = beerq5
label var nbeerq5 "Beer: num other (in half pints)"

local i = 1
while `i' < 5	{
			replace nbeerq1 = beerq`i' if beerm`i'==1
			replace nbeerq2 = beerq`i' if beerm`i'==2
			replace nbeerq3 = beerq`i' if beerm`i'==3
			replace nbeerq4 = beerq`i' if beerm`i'==4
			local i = `i' + 1
			}

* STEP 2: merge all beer data together into one value for beerq
capture drop bunits
gen bunits = 0
replace bunits = bunits + nbeerq1 if nbeerq1<.
replace bunits = bunits + nbeerq2 if nbeerq2<.
replace bunits = bunits + nbeerq4 if nbeerq4<.
replace bunits = bunits + nbeerq5 if nbeerq5<.
replace bunits = bunits + 1.5*nbeerq3 if nbeerq3<.

* STEP 3: create beverage-specific weekly units
capture drop _beer-_alcpop qbeer-qpops dratndns
recode beer shandy spirits sherry wine alcpop (1=7) (2=5.5) (3=3.5) (4=1.5) (5=0.375) (6=0.115) (7=0.029) (8=0), ///
	gen(_beer _shandy _spirits _sherry _wine _alcpop)
gen qbeer = 	bunits * _beer if _beer<.
gen qshandy = 	0.5* shandyq * _shandy if _shandy<.
gen qspirit = 	spiritsq * _spirits if _spirits<.
gen qsherry = 	sherryq * _sherry if _spirits<.
gen qwine = 	wineq * _wine if _wine<.
gen qpops = 	alcpopq * _alcpop if _alcpop<.

gen dratndns = 0
foreach q of varlist qbeer-qpops 	{
						replace dratndns = dratndns + `q' if `q'<.
						}
replace dratndns = . if (beer==.r|beer==.d)
label var dratndns "Interview-based weekly consumption, units"
save allalc, replace

******************************************************************************************************************************************************
******************************************************************************************************************************************************
******************************************************************************************************************************************************

* CARRYING OVER TO GHS DATA USING RANDOM NUMBERS

svyset _n [pweight=diarywgt], vce(linearized)				/*  This weights the interview data according to the sample who completed the diary;
											the interview weight itself is intwgt	*/
svy: mean dratndns if alcundr<.
svy: mean alcundr if alcundr<.


* CREATING COMPARABLE PERCENTILE GROUPS
capture drop grp
gen grp = 0 
_pctile dratndns if dratndns>0 [pw=diarywgt], percentiles (10 20 30 40 50 60 70 80 90 95 99) 
local i = 1	
while `i' < 13	{
			local j = `i' - 1
			if `i' == 1		{
						replace grp = `i' if dratndns<r(r`i') & dratndns>0
						}
			if `i' == 12	{
						replace grp = `i' if dratndns>=r(r`j')
						}
			else			{
						replace grp = `i' if dratndns<r(r`i') & dratndns>=r(r`j')
						}
			scalar grp`i' = r(r`i')
			local i = `i' + 1
			}
svy: proportion grp if dratndns>0 & alcundr<.

* CREATING A SCALING VARIABLE TO CARRY OVER TO THE GHS DATA
capture drop pcdcl*
foreach var of varlist uni_a* uni_b* uni_e* uni0a* uni0b* 	{
							gen p`var' = (alcundr - `var') / alcundr
							svy: mean p`var' if grp~=0, over(grp)
							matrix define m`var' = e(b)
										}
recode puni* (min/0 = 0)


* MOVING OVER TO GHS DATA
cd "Z:\IAS STATA files\GHS 2000-1\stata8"
use working.dta, replace
svyset _n [pweight=weight00], vce(linearized)


* Matching up the groups
capture drop _grp
gen _grp = 0 if drating==0
local i = 1
while `i' < 13	{
			local j = `i' - 1
			if `i' == 1		{
						replace _grp = `i' if drating<grp`i' & drating>0
						}
			else			{
						if `i' == 12	{
									replace _grp = `i' if drating>=grp`j' & drating<.
									}
						else			{
									replace _grp = `i' if drating<grp`i' & drating>=grp`j'
									}
						}
			local i = `i' + 1
			}


* Creating the new vars for daily reduction
capture drop _a* _b* _e* 
gen _ah = drating
local _ah = "muni_ahtot"
gen _al = drating
local _al = "muni_altot"
gen _bm = drating
local _bm = "muni_bmtot"
gen _bh = drating
local _bh = "muni_bhtot"
gen _bl = drating
local _bl = "muni_bltot"
gen _em = drating
local _em = "muni_em1"
gen _eh = drating
local _eh = "muni_eh1"
gen _el = drating
local _el = "muni_el1"
gen _ah0 = drating
local _ah0 = "muni0ahtot"
gen _al0 = drating
local _al0 = "muni0altot"
gen _bm0 = drating
local _bm0 = "muni0bmtot"
gen _bh0 = drating
local _bh0 = "muni0bhtot"
gen _bl0 = drating
local _bl0 = "muni0bltot"


* This simppy uses the matrices generated above (e.g. muni_ahtot) to provide an appropriate multiply, within each _grp
foreach var of varlist _ah-_bl0		{
	label var `var' "Daily decline in consumption: `var'"
	local i = 1
	while `i' < 13	{
				replace `var' = drating * (1-``var''[1,`i']) if _grp==`i'
				local i = `i' + 1
				}
							}

save, replace
